import os
from os import listdir
from os.path import isfile, join

##################
#
# Rude hack to convert Homelab CP/M disks to a usable format
# Included: original and converted disk images
# This python hack, I wrote it while watching some stupid comedy, so feel free to make it proper. :)
# Configuration files for flash floppy/Gotek to replace FDD
# EPROM dump from the FDD interface
#
##################

#sourceFileName="disk27.img"
#sourceFileName="disk8.img"

sourceFileName="disk8.img"

# OK, so we have a format and CP/M use 2 tracks for boot. The non bootable has the file allocation table after the first sector.
# What we do: use the bootable 2 tracks and add the non bootable tracks from file allocation table, but cut the last two sectors. 
# I know a dd can do that, but first I wrote the python to dump the file allocation and info stored there. The hack idea was just a spark and yes it is working :-D

workingDirectory="."
heads=2
tracks=80
sectorSize=1024
sectorPerTrack=5
dirShift=0
dirSize=2048
bootSectors=2

blockSize=sectorSize*sectorPerTrack
blockAmount=heads*tracks

file=open(sourceFileName,"rb")
bootRecordContent=file.read(bootSectors*sectorSize*sectorPerTrack)
file.close()

# Reading file allocation and names. Simply struct would be better in C, but it KISS it now
# Reference: https://obsolescence.wixsite.com/obsolescence/cpm-internals
def diskImageInfo(fileContent,actualSector):
    usedSectors=[]
    lastUsedSector=0
    i=actualSector*blockSize+dirShift
    print ('Owner filename ext attr used space and sectors')
    while i<actualSector*blockSize+dirShift+dirSize:
        fileOwner=fileContent[i]
        fileName=fileContent[i+1:i+8]
        fileExtension=fileContent[i+9:i+12]
        fileAttribs=fileContent[i+12:i+14]
        fileRecords=fileContent[i+15]
        fileDiskMap=fileContent[i+16:i+31]
        if fileOwner==0:
            print (fileOwner,str(fileName),fileExtension,fileAttribs,fileRecords,'', end='')
            a=0
            while a<len(fileDiskMap):
                if fileDiskMap[a]!=0:
                    usedSectors.append(fileDiskMap[a])
                    print (str(fileDiskMap[a])+" ", end='')
                    if lastUsedSector<fileDiskMap[a]:
                        lastUsedSector=fileDiskMap[a]                  
                a=a+1
            print('')
        i=i+32

    file.close()
    # It is great to see allocation, but making messy output. Use it to gain more insight if needed.
    # print ("Used sectors","\n",usedSectors)
    print ("Last used sector:", lastUsedSector)
    return lastUsedSector


# Here we dump the boot part from a working disk and copy over the non working. IT can be done only if they fit into the 160 sectors, but we've checked it already right?
def convertImage(inputFileName,bootRecordContent):
    inputFile=open(inputFileName,"rb")
    outputFile=open("CONVERT_"+inputFileName,"wb")
    inputFileSize=inputFile.seek(0,2)
    inputFile.seek(sectorSize)
    trasferableContent=inputFile.read(inputFileSize-len(bootRecordContent))
    outputFile.write(bootRecordContent)
    outputFile.write(trasferableContent)
    inputFile.close()
    outputFile.close()
    print (' ',len(bootRecordContent),'-> CONVERTED')

imageFileList = [f for f in sorted(listdir(workingDirectory)) if isfile(join(workingDirectory, f)) and f.endswith('.img')]
print (imageFileList)

maximumUSedSector=0
diskList={}


# Walk through the directory
for actualFileName in imageFileList:
    print ('############################################')
    print('Opening image:', actualFileName)
    file=open(actualFileName,"rb")
    fileContent=file.read()
    file.close()
    print('Image length:', len(fileContent))

# Check if it is bootable or we need to hack it
    if fileContent[0:16]!=b'\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00':
        print ('I suspect it is a bootable image.')
        directorySkipSector=bootSectors
        diskImageInfo(fileContent,directorySkipSector)
        diskList[actualFileName]='BOOT'
        print ('I do not touch a disk that looks fine')
    else:
        print ('Probably it is a non bootable image.')
        directorySkipSector=0
        lastUsedSector=diskImageInfo(fileContent,directorySkipSector)
        diskList[actualFileName]=lastUsedSector
print ('Let\'s convert the images')

# Convert if it is not bootable and the last two sectors are not in use.
for imgName, result in diskList.items():
    print (imgName, result, end='')
    try:
        result.isnumeric()
        print(' -> SKIP')
        continue
    except:
        if result<158:
            convertImage(imgName, bootRecordContent)
        else:
            print(' -> Can\'t convert')
